<?php
if (self::$db_alter->fetch_table_info('dbtech_downloads_category'))
{
	self::$db_alter->add_field(array(
		'name'       => 'ownerid',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'moderated',
		'type'       => 'tinyint',
		'length'     => '1',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'dbtech_downloads_category');
}

if (self::$db_alter->fetch_table_info('dbtech_downloads_file'))
{
	self::$db_alter->add_field(array(
		'name'       => 'filepath',
		'type'       => 'varchar',
		'length'     => '256',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => ''
	));
	self::report('Altered Table', 'dbtech_downloads_file');
}

// New tables
self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX . "dbtech_downloads_domain` (
		`domainid` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
		`domain` VARCHAR(150) NOT NULL DEFAULT '',
		`image` VARCHAR(100) NOT NULL DEFAULT '',
		`active` TINYINT(1) NOT NULL DEFAULT '1',
		PRIMARY KEY (`domainid`)
	)
");
self::report('Created Table', 'dbtech_downloads_domain');
?>